#include "operatingsystem.h"
#include "c4d_memory.h"
#include "c4d_basechannel.h"
#include "c4d_file.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"

BaseChannel *BaseChannel::Alloc(void)
{
	return C4DOS.Ba->Alloc();
}

void BaseChannel::Free(BaseChannel *&bc)
{
	if (!bc) return;
	C4DOS.Ba->Free(bc);
	bc=NULL;
}

Bool BaseChannel::Attach(GeListNode *element)
{
	return C4DOS.Ba->Attach(this,element);
}

Bool BaseChannel::Compare(BaseChannel *dst)
{
	return C4DOS.Ba->Compare(this,dst);
}

LONG BaseChannel::InitTexture(InitRenderStruct *is)
{
	return C4DOS.Ba->InitTexture(this,is);
}

void BaseChannel::FreeTexture(void)
{
	C4DOS.Ba->FreeTexture(this);
}
	
BaseContainer BaseChannel::GetData(void)
{
	BaseContainer bc;
	C4DOS.Ba->GetData(this,&bc);
	return bc;
}

void BaseChannel::SetData(const BaseContainer &ct)
{
	C4DOS.Ba->SetData(this,&ct);
}

LONG BaseChannel::GetShaderID(void)
{
	return C4DOS.Ba->GetPluginID(this);
}

PluginShader *BaseChannel::GetShader(void)
{
	return C4DOS.Ba->GetPluginShader(this);
}

TexturePreview::TexturePreview(void)
{
	texgroup = NULL;
}

Bool TexturePreview::InitPreview(TextureGroup *t_texgroup)
{
	texgroup = t_texgroup;
	return TRUE;
}

LONG TexturePreview::Message(const BaseContainer &msg,BaseContainer &result)
{
	if (texgroup) texgroup->Message(msg,TRUE);
	return GeUserArea::Message(msg,result);
}

Bool TexturePreview::GetMinSize(LONG &w,LONG &h)
{
	w = h = 80;
	return TRUE;
}

void TexturePreview::Draw(LONG x1,LONG y1,LONG x2,LONG y2)
{
}

TextureGroup::TextureGroup(void)
{
	tg=NULL;
	cd=NULL;
	bc=NULL;
}

TextureGroup::~TextureGroup(void)
{
	if (tg) C4DOS.Ba->DlgFree(tg);
}

Bool TextureGroup::Init(BaseChannel *cc, GeDialog *dd, LONG idimage, LONG idname, LONG idbluroff, LONG idblurstr, LONG idint, LONG idinfo, LONG idpreview, LONG idedit, LONG idpopup)
{
	bc = cc;
	cd = dd->Get();
	if (!bc) return FALSE;
		
	texprev.InitPreview(this);
	if (idpreview) dd->AttachUserArea(texprev,idpreview);

	tg = C4DOS.Ba->DlgAlloc(bc,dd->Get(),texprev.Get(),idimage,idname,idbluroff,idblurstr,idint,idinfo,idpreview,idedit,idpopup);
	return tg!=NULL;
}

void TextureGroup::Update(void)
{
	if (!tg) return; 
	BaseContainer msg;
	msg.SetId(BFM_INITVALUES);
	C4DOS.Ba->DlgMessage(tg,&msg,FALSE);
}

Bool TextureGroup::Message(const BaseContainer &msg,Bool preview)
{
	if (!tg || !cd || !bc) return FALSE;
	return C4DOS.Ba->DlgMessage(tg,&msg,preview);
}
